﻿
# ===================================================================
# PARTE 1: DEFINIÇÕES GERAIS
# ===================================================================

# 1. PERSONAGENS
define r = Character("Rafael", color="#1a25c5")
define p_pensamento = Character("Pensamento...", color="#d38db3", what_italic=True)
define pc = Character("Prof. Caio", color="#199209")
define m = Character("Marina", color="#f8f40b")
define lu = Character("Lucas", color="#6aab8e")
define narradorNada = Character(None)
define narrador = Character(None, what_color="#87CEEB", what_italic=True, what_size=45)
#Celular
define r_celular = Character(None, kind=nvl)
define l_celular = Character(None, kind=nvl, self_kind=nvl)

# 2. VARIÁVEIS DE JOGO
# ADICIONADO DE VOLTA: As variáveis que controlam a história.
default player_name = "Luna"
default indice_abuso = 0
default relacionamento_rafael = 0


# 3. IMAGENS E ÁUDIO
# Cenários
image bg sala dia = "images/Sala de Aula Tarde.png"
image bg parque noite = "images/parque_noite.png"
image bg quarto noite = "images/quarto_femnoite.png"
image bg corredor = "images/corredor.png"
image bg biblioteca = "images/Biblioteca Dia.png"
image bg Quintal = "images/Quintal.png"
image black = "#000000"
image red_flash = Solid("#ff0000")
image black_overlay = Solid("#00000080")

transform posicao_ataque:
    xalign 0.80 
transform escurecida:
    matrixcolor Brightness(-0.5)

# Personagens (sprites)
image luna neutra:
    "images/menina_normal.png"
    zoom 1.5

image luna feliz:
    "images/menina_alegre.png"
    zoom 1.5

image luna arrumada:
    "images/Luna arrumada.png"
    zoom 0.6


image luna arrumada brava:
    "images/Luna arrumada brava.png"
    zoom 0.5

image luna agredida:
    "images/menina_agredida.png"
    zoom 1.5
    yalign 2.5

image luna agredida brava:
    "images/menina_agredidaBrava.png"
    zoom 1.5
    yalign 2.5

image rafael sorrindo :
    "images/homem_parado.png"
    zoom 1.2

image rafael irritado:
    "images/homem_chateado.png"
    zoom 1.2
    
image rafael bravo:
    "images/homem_nervoso.png"
    zoom 1.2

image rafael agressivo:
    "images/homem_agressivo.png"
    zoom 0.6

image rafael soco:
    "images/homem_soco.png"
    zoom 0.6

image homem flor:
    "images/homem_flor.png"
    zoom 0.6

image prof caio neutro:
    "images/Professor.png"
    zoom 1.1

image marina neutra:
    "images/amiga_normal.png"
    zoom 1.1

image lucas sorrindo:
    "images/lucas_sorrindo.png"
    zoom 0.5


# ===================================================================
# PARTE 2: A HISTÓRIA DO JOGO
# ===================================================================

label splashscreen:
    call screen warning_screen

label start:
    $ player_name = renpy.input("Por favor, digite o nome da sua personagem:", default="Luna", length=15).strip()
    if not player_name:
        $ player_name = "Luna"
    $ l = Character("[player_name]", color="#e87cb7")

    # --- CENA 1: A APRESENTAÇÃO  ---

    scene bg sala dia with fade
    play music "audio/ambiente_corredor.ogg" loop

    show prof caio neutro at center
    pc "Bom dia, turma. Antes de começarmos a aula, queria apresentar um novo colega que está se juntando a nós hoje."
    pc "Este é o Rafael! Ele veio transferido de outra cidade. Espero que o recebam bem!"
    hide prof caio neutro
    pc "Rafael, pode se sentar ali, na carteira ao lado da [player_name]."

    show rafael sorrindo at right with move
    r "Oii, acho que vamos ser parceiros nos trabalhos agora..."
    show luna neutra at left

    menu:
        "Puxar assunto":
            $ relacionamento_rafael += 2
            $ renpy.notify("+2 Proximidade com Rafael")
            l "Prazer, sou a [player_name]! Se precisar de qualquer coisa com a matéria ou pra conhecer a escola, é só falar..."
            r "Valeu mesmo, [player_name]! Gentil da sua parte."

            jump aula_historia

        "Responder simpaticamente, mas sem muito papo":
            $ relacionamento_rafael += 1
            $ renpy.notify("+1 Proximidade com Rafael")
            l "Oii, seja bem-vindo! Sou a [player_name]."
            r "Obrigado. Parece que dei sorte de sentar do lado de alguém legal."

            jump aula_historia

        "Ignorar e apenas acenar com a cabeça":
            p_pensamento "(Apenas aceno com a cabeça, um pouco sem graça.)"
            r "..."
            r "Ok... A gente se fala depois então..."
            jump aula_historia

# ===================================================================
# PARTE 2: A AULA DE HISTÓRIA
# ===================================================================

label aula_historia:
    
    # Limpamos a tela da cena anterior
    hide rafael sorrindo
    hide luna neutra

    # A aula continua...
    show prof caio neutro at center

    pc "Muito bem, pessoal. O tema deste bimestre será sobre as grandes revoluções..."
    pc "E o que acontece quando um líder carismático, que promete liberdade, começa a usar o medo para manter o poder?"
    pc "Onde fica a linha que separa o protetor do opressor?"
    p_pensamento "(Uau... pergunta profunda.)"

    pc "E é sobre isso que será o nosso grande seminário em duplas. Eu já formei os pares..."

    # Mostramos a protagonista e a Marina para a reação
    hide prof caio neutro
    show luna neutra at left
    show marina neutra at right

    p_pensamento "(Tomara que eu caia com a Marina...)"
    m "(Cruza os dedos!)" # Marina pode ter falas sem o nome, como se fossem sussurros

    show prof caio neutro at center

    pc "E a dupla final será... [player_name] e Rafael."

    # Descrevemos as reações em vez de mostrar o Rafael
    p_pensamento "(Olho para a Marina, que me lança um olhar de 'ih, amiga... boa sorte.)"
    p_pensamento "(Do outro lado da sala, vejo o Rafael sorrir na minha direção.)"

    # O pensamento da protagonista muda baseado na primeira escolha!
    if relacionamento_rafael >= 2:
        p_pensamento "(Nossa... Dupla com o aluno novo! Pelo menos ele foi super simpático, acho que vai ser legal.)"
    elif relacionamento_rafael == 1:
        p_pensamento "(Em dupla com o Rafael... Ok. Ele parece ser gente boa, vamos ver.)"
    else:
        p_pensamento "(Com o aluno novo? Que droga... mal falei com ele. Espero que ele se esforce no trabalho.)"

    hide luna neutra
    hide marina neutra
    hide prof caio neutro

    # Som do sinal da escola
    play sound "audio/sinal_escola.ogg"
    
    p_pensamento "(O sinal tocou, encerrando a aula. Preciso falar com o Rafael sobre o trabalho.)"

    jump cena_corredor
# ===================================================================
# PARTE 3: A CONVERSA NO CORREDOR
# ===================================================================

label cena_corredor:

    # Limpamos a tela e preparamos o novo cenário
    hide luna neutra
    hide marina neutra
    hide prof caio neutro
    
    scene bg corredor with fade
    stop music fadeout 1.0
    play sound "audio/ambiente_corredor.ogg"  

    # A protagonista e a Marina conversam
    show luna feliz at left
    show marina neutra at right

    m "E aí, [player_name]! Que sorte, hein? Fazer dupla com o novato bonitinho."
    l "Para com isso, Marina! É só um trabalho."
    m "Sei... Mas e aí, já falaram sobre o que vão fazer?"
    l "Ainda não, a aula acabou de acabar..."

    # Rafael se aproxima, interrompendo a conversa
    hide marina neutra
    show rafael sorrindo at right with moveinright

    r "Oi, [player_name]. Desculpa interromper."
    l "Oi, Rafael! Sem problemas... Essa é a Marina, minha melhor amiga!"
    r "Prazer, Marina."
    
    # Ele vai direto ao ponto
    r "Eu só vim pegar seu número pra gente já combinar de fazer o trabalho."
    
    # A "Bandeira Vermelha", disfarçada de dedicação
    r "Pensei que, pra gente se focar melhor, era bom a gente fazer só nós dois, sabe? Pra não ter muita distração..."
    
    # A primeira escolha que afeta o Índice de Abuso
    menu:
        "Concordar, mas incluindo a Marina.":
            # ESCOLHA SAUDÁVEL
            l "Claro, te passo meu número. E podemos fazer nós dois sim, mas se a Marina quiser ajudar a gente a estudar, ela é ótima em história!"
            
            show marina neutra at center # Trazemos a Marina de volta para a reação
            m "É verdade, contem comigo!"
            
            r "Ah... ok, tudo bem."
            p_pensamento "(Ele pareceu meio sem graça, mas concordou. Normal, eu acho...)"

        "Concordar com a ideia dele.":
            # ESCOLHA PREJUDICIAL
            $ indice_abuso += 1
            $ renpy.notify("⚠️ +1 Índice de Abuso")

            l "Sim, você tem razão. Melhor só nós dois pra não ter distração. Te passo meu número."
            r "Perfeito, penso do mesmo jeito!"
            
            show marina neutra at center with dissolve
            p_pensamento "(A Marina ficou meio quieta de repente... mas o Rafael só quer que o trabalho saia bem feito, né?)"

    narradorNada "(Trocamos os números e o sinal para a próxima aula tocou.)"

    jump passagem_de_tempo_montagem

# ===================================================================
# PARTE 4: A PASSAGEM DE TEMPO E O PEDIDO DE NAMORO
# ===================================================================

label passagem_de_tempo_montagem:

    # Limpamos a tela e preparamos a passagem de tempo
    hide luna feliz
    hide marina neutra
    hide rafael sorrindo
    stop sound
    stop music fadeout 2.0

    scene black with fade
    play sound "audio/som_transicao_tempo.ogg"
    narrador "Semanas depois..."
    stop sound

    # --- A MONTAGEM ---

    # Mini-cena 1: Momentos Bons (A diversão)
    scene bg biblioteca with fade
    show luna feliz at left
    show rafael sorrindo at right
    p_pensamento "(Nessas últimas semanas, eu e o Rafael nos aproximamos muito por causa do trabalho.)"
    l "Haha, essa parte da história é muito bizarra!"
    r "Mas pelo menos é divertido pesquisar com você."
    p_pensamento "(Nós passávamos quase todo o tempo juntos...)"

    # Mini-cena 2: Momentos Bons (A Conexão)
    p_pensamento "(E começamos a descobrir que tínhamos muito em comum.)"
    p_pensamento "(Estava ouvindo a minha banda favorita para relaxar...)"
    r "Ei, o que está escutando?"
    l "Ah, é 'Os Viajantes Noturnos'. Não deve conhecer, é meio antigo."
    r "Não acredito! É a minha banda favorita também! Ninguém mais ouve isso!"
    p_pensamento "(Ficamos horas conversando sobre música. Parecia que ele realmente me entendia.)"
    
    # O Conflito Interno
    p_pensamento "(Mas... ele também era intenso... Às vezes, até demais.)"

    # Mini-cena 3: O Controle Digital
    scene bg quarto noite with fade
    hide luna feliz
    hide rafael sorrindo
    window show
    nvl clear
    play sound "mensagem.ogg"
    r_celular "O que está fazendo?"
    play sound "mensagem.ogg"
    r_celular "Com quem vc tá?"
    play sound "mensagem.ogg"
    r_celular "Me responde [player_name]."
    play sound "mensagem.ogg"
    r_celular "Por que vc some tanto? Tá falando com quem?"
    window hide
    $ indice_abuso += 1
    $ renpy.notify("⚠️ +1 Índice de Abuso")
    nvl clear
    p_pensamento "(As mensagens eram o dia inteiro, todos os dias.)"

    # Mini-cena 4: O Isolamento
    scene bg corredor with fade
    show luna feliz at left
    show marina neutra at right
    m "Amiga, vamos ao cinema sábado? Chamei a Carol!"
    l "Claro! Com certeza..."
    show rafael sorrindo at center with moveinright
    r "Opa, [player_name]! Que bom que te encontrei. Pensei que sábado podíamos adiantar a parte final do trabalho, só nós dois."
    l "Ah... tudo bem. Marina, desculpa, não vai dar outra vez..."
    hide luna feliz
    hide marina neutra
    hide rafael sorrindo

    # 1. A tela escurece lentamente.
    scene black with fade

    # 3. O pensamento final aparece na tela preta.
    p_pensamento "(Apesar de tudo, dos momentos estranhos e da intensidade...)"
    p_pensamento "(Eu sentia que ninguém nunca tinha me entendido como ele! Eu estava me apaixonando pelo Rafa...)"
    play sound "audio/som_transicao_tempo.ogg"
    # 4. O texto que marca o tempo surge.
    narrador "Duas semanas depois..."
    stop sound 

    # --- O PEDIDO DE NAMORO ---
    scene bg parque noite with fade
    play music "audio/Romantico.ogg" loop

    show luna feliz at left
    show rafael sorrindo at right

    p_pensamento "(E então, naquela noite, ele me chamou para conversar.)"
    r "[player_name], estas últimas semanas com você têm sido incríveis. A gente se conecta de um jeito que eu nunca senti antes."
    r "Eu sinto que preciso ter você na minha vida, de verdade."
    r "Você quer namorar comigo?"

    # ===================================================================
    # PARTE 5: A DECISÃO
    # ===================================================================
    scene black with fade
    # 1. A HESITAÇÃO (Os pensamentos dela aparecem ANTES da escolha)
    p_pensamento "(Por um segundo, a imagem da Marina me olhando com preocupação veio à minha cabeça... A forma como ele ficava irritado...)"
    p_pensamento "(Aquelas mensagens o tempo todo... Ele me afastando dos meus amigos...)"
    p_pensamento "(Mas... e os momentos bons? As conversas sobre música? O jeito que ele olha para mim...)"
    p_pensamento "(Eu nunca senti isso por ninguém antes!)"

    # A cena volta, focando na ansiedade dele
    scene bg parque noite with fade

    narradorNada "Você volta à realidade. Rafael te encara, com os olhos cheios de expectativa"
    narradorNada "O sorriso dele vacila por um instante, ansioso pela sua resposta..."

    p_pensamento "(E agora? Eu aceito ou não?)"

    # O menu com a escolha única aparece
    menu:
        "Sim... eu aceito!":
            
            show luna feliz at left with dissolve
            l "Sim! Sim, eu aceito!"
    
            show rafael sorrindo at right with dissolve
            
            r "Você não vai se arrepender. Eu juro. Vou te fazer a garota mais feliz do mundo!"

            # A transição para o beijo
            scene black with fade
            
            narrador "E, ali, sob a luz da lua, eles se beijaram pela primeira vez..."
            narrador "O beijo foi intenso, cheio de promessas"
            
            pause 2.0
            
            scene bg parque noite with fade
            show luna feliz at left
            show rafael sorrindo at right

            r "Finalmente. Agora você é minha. Só minha!"
            $ indice_abuso += 1
            $ renpy.notify("⚠️ +1 Índice de Abuso")

            p_pensamento "(Só minha... Senti um arrepio, mas um arrepio bom...)"
            p_pensamento "(Era isso que eu queria. Alguém que me quisesse por inteiro)"
            p_pensamento "(Finalmente encontrei alguém que me entende de verdade. O que poderia dar errado?)"
            
            jump parte6_crise_ciumes
# ===================================================================
# PARTE 6: O NAMORO - A CRISE DE CIÚMES
# ===================================================================

label parte6_crise_ciumes:

    hide luna feliz
    hide rafael sorrindo
    stop music

    scene black with fade
    play sound "audio/som_transicao_tempo.ogg"
    narrador "Meses depois..."
    stop sound

    # A cena começa no corredor
    scene bg corredor with fade
    play music "audio/ambiente_corredor.ogg" loop

    # A conversa inocente com o novo amigo
    show luna feliz at left
    show lucas sorrindo at right

    lu "Eu não acredito que você respondeu isso na prova! Hahaha!"
    l "Eu entrei em pânico! Pelo menos o professor levou na brincadeira..."
    lu "A gente se vê depois então, [player_name]."
    l "Até mais, Lucas!"

    hide lucas sorrindo
    show rafael bravo at right with dissolve

    p_pensamento "(Me virei para ir para a próxima aula e dei de cara com o Rafael. Ele estava parado ali... há quanto tempo?)"
    l "Oii amor! Nem te vi ai"
    r "Percebi... Quem era aquele?"

    narradorNada "(O tom de voz dele era frio. O sorriso desapareceu.)"
    l "O Lucas amor, um amigo da aula de química. Porquê?"

    show rafael bravo at right with dissolve
    r "Pareciam bem íntimos. Rindo trocando segredinhos. Estava flertando com ele?"
    
    $ indice_abuso += 1
    $ renpy.notify("⚠️ +1 Índice de Abuso")
    show luna neutra at left with dissolve
    l "O quê? Claro que não! Ele é só um amigo, estávamos falando da prova?!"
    r "Não foi o que pareceu. Eu não gosto do jeito que ele olhava para você..."
    
    # A manipulação / "Disfarce"
    narradorNada "(Ele percebeu que eu fiquei assustada. A expressão dele suavizou na hora)"
    show rafael sorrindo at right with dissolve

    r "Desculpa amor. Desculpa. É que... eu confio em você, mas não confio nesses moleques."
    r "Eu tenho tanto medo de te perder. Você é tudo para mim."

    l "Não precisa de ter medo..."
    r "Eu sei. Vem cá."
    narradorNada "(Ele me abraçou com força...)"
    show luna feliz at left with dissolve
    r "Vamos esquecer isto. Deixa-me te levar para casa"

    p_pensamento "(Ele só se preocupa comigo. É bom ter alguém que cuida de mim assim... né?)"

    jump parte_final

# ===================================================================
# PARTE FINAL: O CLÍMAX 
# ===================================================================

label parte_final:
    
    # --- A Passagem de Tempo Final ---
    hide luna feliz
    hide rafael sorrindo
    stop music 

    scene black with fade
    play sound "audio/som_transicao_tempo.ogg"
    narrador "Meses depois..."
    stop sound

    # --- A Cena do Confronto ---
    scene bg quarto noite with fade


    show luna arrumada at center with dissolve
    p_pensamento "(Finalmente! Aniversário da Marina. Vai ser bom sair um pouco com o pessoal.)"
    
    show rafael bravo at right with dissolve
    
    l "Oi, amor! Tô quase pronta. O que você acha?"
    r "Você vai com essa roupa?"

    # --- A Discussão ---
    show luna arrumada at center with dissolve
    l "Vou... Qual o problema?"
    
    show rafael agressivo at right with dissolve
    r "Aquele seu amiguinho, o Lucas... ele vai estar lá, né?"
    l "O Lucas? Sim, a turma toda vai. Por quê?"
    r "Entendi agora pra quem você tá se arrumando toda."
    
    show luna arrumada brava at center with dissolve
    l "Para de ser paranoico! O Lucas é só meu amigo!"
    r "Não mente pra mim! Você não vai nessa festa!"

    # --- O Bloqueio Físico ---
    p_pensamento "(Cansei disso. Eu não vou perder o aniversário da minha melhor amiga)"
    hide luna arrumada brava
    hide rafael agressivo
    
    narradorNada "Com o coração acelerado, você se vira e anda em direção à porta"
    
    show luna arrumada brava at center with moveinright
    pause 0.5
    show rafael agressivo at left with moveinright
    
    r "Eu disse que você não vai!"
    l "Sai da minha frente Rafael!"

    # --- A ESCOLHA FINAL ---
    menu:
        "Gritar com ele":
            l "SAI DA MINHA FRENTE AGORA, RAFAEL! VOCÊ NÃO MANDA EM MIM!"
            r "VOCÊ NÃO GRITA COMIGO!"
            narradorNada "A raiva dele explode"
            narradorNada "Ele te empurra com força"
            jump climax_agressao

        "Empurrar e tentar sair":
            narradorNada "Você junta toda a sua coragem e o empurra, tentando abrir caminho"
            r "Ah, agora você quer me empurrar? Quer me bater, é isso?"
            narradorNada "Ele segura seus braços com muito mais força"
            l "ME SOLTA!"
            narradorNada "Ele te joga com força na cama"
            jump climax_agressao

    # --- O CLÍMAX (Comum a ambas as escolhas) ---
label climax_agressao:
    
    # O Ataque
    window hide
    show rafael soco at posicao_ataque with move
    l "NÃO!"

    scene black with Dissolve(0.1)
    show red_flash
    play sound "audio/soco.ogg"
    with Dissolve(0.1)
    stop sound
    hide red_flash
    with Dissolve(0.2)
    stop music
    play sound "audio/atordoado.ogg"
    p_pensamento "(...dor...)"
    p_pensamento "(...zumbido no meu ouvido...)"
    p_pensamento "(...não consigo respirar...)"

    scene black with fade

    narradorNada "Rafael vai embora sem dizer nada "

    scene bg quarto noite with Dissolve(1.0)
    p_pensamento "(Eu não sei o que fazer...)"
    p_pensamento "(Acho melhor eu tirar essa roupa...)"
    stop sound fadeout 1.0

    pause 1.0
    show luna agredida with dissolve
    
    jump climax_reflexao

label climax_reflexao:  
    p_pensamento "(Ele... ele realmente... me bateu?)"
    p_pensamento "(Não. Não pode ser real. Eu devo ter imaginado)"

    # 2. A Realidade Física
    pause 2.0
    p_pensamento "(Meu braço... meu rosto... está doendo tanto)"
    p_pensamento "(A dor é real. Então... aconteceu mesmo)"

    # 3. A Tentativa de Entender
    p_pensamento "(Como isso aconteceu? A gente estava só... discutindo)"
    p_pensamento "(Uma roupa... e ele... ele gritou. Ele me agarrou)"
    p_pensamento "(Ele me empurrou)"

    # 4. A Auto-Culpa
    pause 2.5
    p_pensamento "(Foi culpa minha?)"
    p_pensamento "(Eu não devia ter gritado com ele... Eu não devia ter insistido em ir à festa...)"
    p_pensamento "(Se eu tivesse trocado de roupa, como ele pediu, nada disso teria acontecido...)"

    # 5. A Confusão
    p_pensamento "(Não... não, ele não tinha o direito. Ninguém tem o direito de fazer isso!)"
    p_pensamento "(Mas... aquele não era o Rafael. O Rafael que eu conheço é carinhoso, ele é divertido...)"
    p_pensamento "(Ele deve estar arrependido. Ele nunca quis fazer isso...)"

    # 6. O Medo e a Vergonha
    p_pensamento "(O que eu faço agora? Ligo para a Marina? Ligo para a minha mãe?)"
    p_pensamento "(Não... que vergonha. O que eu ia dizer? Ninguém pode saber disso)"
    p_pensamento "(Eu só quero que isso desapareça. Que isso não tivesse acontecido)"

    # Pulamos para a chegada do Rafael
    jump climax_perdao

label climax_perdao:
    scene black with fade
    narrador "Algumas horas depois..."
    
    play sound "audio/campainha.ogg"
    scene bg quarto noite with Dissolve(1.0)
    show luna agredida with dissolve
    
    p_pensamento "(É ele... O que eu faço?)"
    narradorNada "Você respira fundo e abre a porta"

    scene black with fade
    pause 1.0
    scene bg Quintal with Dissolve(1.0)
    show luna agredida with dissolve
    pause 1.0
    show homem flor at right with easeinright 
    
    r "(chorando) Desculpa amor... Por favor, me perdoa..."
    r "Eu não sei o que deu em mim. Eu te amo tanto que perco a cabeça"
    r "Isso nunca, nunca mais vai acontecer. Eu juro..."
    
    menu:
        "Mandar ele embora":
            # --- ROTA DA LIBERTAÇÃO ---
            l "Vai embora Rafael!"
            r "Não, amor, por favor, me escuta..."
            
            # A protagonista usa a imagem de 'brava' para mostrar sua determinação
            show luna agredida brava with dissolve
            l "Eu não quero mais te ver! Acabou! Vai embora daqui! AGORA!"
            
            narradorNada "(Ele me olha, chocado. Pela primeira vez, ele parece sem palavras)"
            hide homem flor with easeoutleft
            pause 0.6
            show luna agredida with dissolve
            p_pensamento "(Dói... Dói muito...)"
            p_pensamento "(Mas eu sei que fiz a coisa certa)"
            
            l "(pegando o celular) Marina...? Você pode vir aqui?"
            scene black with fade
            pause 1.0
            call screen final_libertacao_screen
            
            # Retorna para o menu principal após o fim
            return

        "Acreditar nele":
            # --- ROTA DO CICLO ---
            $ indice_abuso += 5
            $ renpy.notify("⚠️ +5 Índice de Abuso")

            l "..."
            l "Você... você jura que nunca mais...?"
            r "Eu juro, [player_name]. Eu juro pela minha vida. Eu te amo tanto, me perdoa..."

            scene bg quarto noite with Dissolve(1.0)
            
            narradorNada "(Ele me abraça com força. O cheiro das flores invade o quarto)"
            p_pensamento "(Eu amo ele... Ele vai mudar. Eu sei que ele vai...)"
            scene black with fade
            pause 1.0
            
            call screen final_ciclo_screen

            label transicao_para_creditos:
    
    window hide
    scene black with Dissolve(0.5)
    pause 0.2
    call screen credits_screen
    return
